using System.Data;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;
using System.Data.SqlClient;
using System.Data.SqlTypes;

namespace gov.va.med.vbecs.DAL
{
		#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Mike      </Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>1/17/2003</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	///	Data access component providing database 
	///	access to reagent manufacturer data
	///</summary>

		#endregion

	public class ReagentManufacturer
	{

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/27/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1066"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>DataTable of reagent manufacturers.</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="1277"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		///  Gets a list of reagent manufacturers
		/// </summary>
		/// <returns>DataTable containing reagent manufacturers data</returns>
		public static DataTable GetListOfManufacturers()
		{
			SqlParameter[] prms =
				{
					new SqlParameter(STOREDPROC.GetReagentManufacturers.divisioncode, SqlDbType.VarChar)

				};

			prms[0].Value = Common.LogonUser.LogonUserDivisionCode;

			return Common.StoredProcedure.GetData(STOREDPROC.GetReagentManufacturers.StoredProcName, prms).Tables[0];
		}
	}
}

